/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class ConveyorDetectorUpgrade
extends ConveyorUpgrade {
    public static VoxelShape BB = Shapes.m_83048_((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.075, (double)0.8125);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean hasEntity = false;
    private boolean whitelist = false;
    private boolean inverted = false;

    public ConveyorDetectorUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void update() {
        if (this.getWorld().f_46443_) {
            return;
        }
        boolean previous = this.hasEntity;
        this.hasEntity = false;
        List entities = this.getWorld().m_45976_(Entity.class, this.getBoundingBox().m_83215_().m_82338_(this.getPos()).m_82400_(0.01));
        boolean bl = this.hasEntity = !entities.isEmpty() && this.whitelist == this.someoneMatchesFilter(entities);
        if (this.inverted) {
            boolean bl2 = this.hasEntity = !this.hasEntity;
        }
        if (previous != this.hasEntity) {
            this.getWorld().m_46672_(this.getPos(), this.getWorld().m_8055_(this.getPos()).m_60734_());
        }
    }

    private boolean someoneMatchesFilter(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!this.filter.matches(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT() == null ? new CompoundTag() : super.serializeNBT();
        compound.m_128365_("Filter", (Tag)this.filter.serializeNBT());
        compound.m_128379_("Whitelist", this.whitelist);
        compound.m_128379_("Inverted", this.inverted);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (nbt.m_128441_("Filter")) {
            this.filter.deserializeNBT(nbt.m_128469_("Filter"));
        }
        this.whitelist = nbt.m_128471_("Whitelist");
        this.inverted = nbt.m_128471_("Inverted");
    }

    @Override
    public int getRedstoneOutput() {
        return this.hasEntity ? 15 : 0;
    }

    @Override
    public VoxelShape getBoundingBox() {
        return BB;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean ignoresCollision() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.m_41712_((CompoundTag)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
        if (buttonId == 17) {
            this.inverted = !this.inverted;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorDetectorUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorDetectorUpgrade.this.whitelist ? 0 : 1;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(17, 133, 55, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 96, 214, new String[]{"redstone_normal"}), new StateButtonInfo(1, res, 77, 214, new String[]{"redstone_inverted"})}){

            @Override
            public int getState() {
                return ConveyorDetectorUpgrade.this.inverted ? 1 : 0;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("detection");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorDetectorUpgrade(container, this, face);
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Collections.singleton(new ResourceLocation("industrialforegoing", "blocks/conveyor_detection_upgrade"));
        }

        @Override
        @Nonnull
        public Set<Direction> getValidFacings() {
            return DOWN;
        }

        @Override
        public Direction getSideForPlacement(Level world, BlockPos pos, Player player) {
            return Direction.DOWN;
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_detection");
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_detection_upgrade");
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).m_126130_("IPI").m_126130_("IDI").m_126130_("ICI").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)Blocks.f_50165_).m_126127_(Character.valueOf('D'), (ItemLike)Blocks.f_50328_).m_126127_(Character.valueOf('C'), (ItemLike)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get()).m_176498_(consumer);
        }
    }
}

